package ru.yandex.logbroker.log.consumer.integration.click;

import java.util.function.Function;
import java.util.function.Supplier;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.logger.PrefixedLogger;

public class LoggableProducerSupplier<T extends HttpAsyncRequestProducer>
    implements Supplier<T>
{
    private final Function<HttpHost, T> generator;
    private final HttpHost host;
    private final PrefixedLogger logger;

    public LoggableProducerSupplier(
        final Function<HttpHost, T> generator, final HttpHost host,
        final PrefixedLogger logger)
    {
        this.generator = generator;
        this.host = host;
        this.logger = logger;
    }

    public PrefixedLogger logger() {
        return logger;
    }

    @Override
    public T get() {
        return generator.apply(host);
    }
}
