package ru.yandex.logbroker.log.consumer.integration.mtype;

import java.io.IOException;
import java.util.Collections;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logbroker.log.consumer.LuceneFunctions;
import ru.yandex.logbroker.log.consumer.integration.SlaveClickConsumer;
import ru.yandex.logbroker.log.consumer.integration.click.UserAction;
import ru.yandex.stater.AbstractStatable;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class MtypeClickConsumer
    extends AbstractStatable
    implements SlaveClickConsumer
{
    private static final String SEPARATOR = "_";
    private static final String URL = "url";
    private static final String MTYPE_URL_PREFIX = "umtype" + SEPARATOR;
    private static final String COUNT_FIELD = "mtype_show_count";

    private final TimeFrameQueue<Long> skip;
    private final TimeFrameQueue<Long> ok;
    private final TimeFrameQueue<Long> fail;

    public MtypeClickConsumer(final ImmutableBaseServerConfig config) {
        ok = new TimeFrameQueue<>(config.metricsTimeFrame());
        skip = new TimeFrameQueue<>(config.metricsTimeFrame());
        fail = new TimeFrameQueue<>(config.metricsTimeFrame());

        registerStater(
            new PassiveStaterAdapter<>(
                ok,
                new NamedStatsAggregatorFactory<>(
                    "integration-update-mtype-consumer-ok_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                skip,
                new NamedStatsAggregatorFactory<>(
                    "integration-update-mtype-consumer-skip_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                fail,
                new NamedStatsAggregatorFactory<>(
                    "integration-update-mtype-consumer-fail_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));
    }

    @Override
    public void indexed() {
        ok.accept(1L);
    }

    @Override
    public void failed() {
        fail.accept(1L);
    }

    @Override
    public void skip() {
        skip.accept(1L);
    }

    @Override
    public boolean enabled(final UserAction click) {
        return click.search() && !click.mtypes().isEmpty();
    }

    private String buildMap(final UserAction click) {
        StringBuilder sb = new StringBuilder();
        Collections.sort(click.mtypes());

        for (Integer mtype: click.mtypes()) {
            sb.append(mtype);
            sb.append(",");
        }

        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }

        sb.append("\t1\n");
        sb.append("all\t1");
        return sb.toString();
    }

    @Override
    public void write(
        final JsonWriter writer,
        final UserAction click)
        throws IOException
    {
        writer.startObject();
        writer.key(URL);
        writer.value(MTYPE_URL_PREFIX + click.prefix());
        LuceneFunctions.createSumMapFunction(
            writer,
            COUNT_FIELD,
            buildMap(click));
        writer.endObject();
    }
}
