package ru.yandex.logbroker.log.consumer.integration.requests;

import java.io.IOException;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logbroker.log.consumer.integration.SlaveClickConsumer;
import ru.yandex.logbroker.log.consumer.integration.click.UserAction;
import ru.yandex.stater.AbstractStatable;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class RequestsClickConsumer
    extends AbstractStatable
    implements SlaveClickConsumer
{
    private static final String SEPARATOR = "_";
    private static final String URL = "url";
    private static final String REQUEST_URL_PREFIX = "reqs" + SEPARATOR;

    private final TimeFrameQueue<Long> skip;
    private final TimeFrameQueue<Long> ok;
    private final TimeFrameQueue<Long> fail;

    public RequestsClickConsumer(final ImmutableBaseServerConfig config) {
        ok = new TimeFrameQueue<>(config.metricsTimeFrame());
        skip = new TimeFrameQueue<>(config.metricsTimeFrame());
        fail = new TimeFrameQueue<>(config.metricsTimeFrame());

        registerStater(
            new PassiveStaterAdapter<>(
                ok,
                new NamedStatsAggregatorFactory<>(
                    "integration-update-requests-consumer-ok_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                skip,
                new NamedStatsAggregatorFactory<>(
                    "integration-update-requests-consumer-skip_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));
        registerStater(
            new PassiveStaterAdapter<>(
                fail,
                new NamedStatsAggregatorFactory<>(
                    "integration-update-requests-consumer-fail_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));
    }

    @Override
    public void skip() {
        skip.accept(1L);
    }

    @Override
    public void indexed() {
        ok.accept(1L);
    }

    @Override
    public void failed() {
        fail.accept(1L);
    }

    @Override
    public boolean enabled(final UserAction click) {
        return click.search()
            && click.request() != null
            && click.mid() != null
            && !click.request().trim().isEmpty();
    }

    @Override
    public void write(
        final JsonWriter writer,
        final UserAction click)
        throws IOException
    {
        writer.startObject();
        writer.key(URL);
        writer.value(
            REQUEST_URL_PREFIX + click.prefix()
                + SEPARATOR + click.request());
        writer.key("type");
        writer.value("mail_request_history");
        writer.key(MailIndexFields.REQUEST_MIDS);
        writer.value(click.mid());
        writer.endObject();
    }
}
