package ru.yandex.logbroker.log.consumer.sherlock;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logbroker.log.consumer.LogConsumer;
import ru.yandex.logbroker.log.consumer.LuceneFunctions;
import ru.yandex.logbroker.log.consumer.integration.click.IndexationClient;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.uri.QueryConstructor;

public class SherlockTemplatesConsumer implements LogConsumer<JsonMap> {
    private static final String PREFIX_PARAM = "prefix";

    private final PrefixedLogger logger;
    private final SherlockTemplatesTskvParser parser;
    private final ImmutableHttpHostConfig hostConfig;
    private final IndexationClient client;

    //CSOFF: ParameterNumber
    public SherlockTemplatesConsumer(
        final PrefixedLogger logger,
        final IndexationClient client,
        final ImmutableHttpHostConfig hostConfig,
        final SherlockTemplatesTskvParser parser)
    {
        this.logger = logger;
        this.parser = parser;
        this.hostConfig = hostConfig;
        this.client = client;
    }
    //CSON: ParameterNumber

    @Override
    public void apply(
        final JsonMap record,
        final FutureCallback<Object> callback)
    {
        MailTemplates templates = parser.apply(record);
        if (templates == null) {
            callback.completed(null);
        } else {
            client.execute(
                hostConfig.host(),
                new BasicAsyncRequestProducerGenerator(
                    uri(templates),
                    body(templates)),
                EmptyAsyncConsumerFactory.ANY_GOOD,
                callback);
        }
    }

    private String body(final MailTemplates templates) {
        StringBuilderWriter sbWriter = new StringBuilderWriter();
        try (JsonWriter writer = new JsonWriter(sbWriter)) {
            writer.startObject();
            writer.key(PREFIX_PARAM);
            writer.value(templates.prefix());
            writer.key("AddIfNotExists");
            writer.value(true);
            writer.key("PreserveFields");
            writer.startArray();
            writer.value(MailIndexFields.SHERLOCK_MID);
            writer.endArray();
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("url");
            StringBuilder sb = new StringBuilder("shrlck_");
            sb.append(templates.prefix().toStringFast());
            sb.append('_');
            sb.append(templates.stid());
            writer.value(sb.toString());
            LuceneFunctions.makeSetFunction(
                writer,
                MailIndexFields.SHERLOCK_TEMPLATES,
                templates.tids());
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException ioe) {
            logger.log(
                Level.WARNING,
                "Failed to construct body for click",
                ioe);
            return null;
        }

        return sbWriter.toString();
    }

    private String uri(final MailTemplates templates) {
        QueryConstructor uri = new QueryConstructor("/update?");

        try {
            uri.append("service", "change_log");
            uri.append(
                PREFIX_PARAM,
                templates.prefix().toString());
            uri.append("logbroker", "sherlock_consumer");
        } catch (BadRequestException bre) {
            logger.log(
                Level.SEVERE,
                "Unable construct producer request " + templates.toString(),
                bre);
            return null;
        }

        return uri.toString();
    }
}
