package ru.yandex.logbroker.log.consumer.sherlock;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.http.message.BasicHttpRequest;

import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.SharedConnectingIOReactor;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.logbroker.config.LogConfig;
import ru.yandex.logbroker.log.consumer.JsonLogConsumerFactory;
import ru.yandex.logbroker.log.consumer.LogConsumer;
import ru.yandex.logbroker.log.consumer.integration.click.IndexationClient;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.stater.AbstractStatable;
import ru.yandex.stater.IntegralSumAggregatorFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;

public class SherlockTemplatesConsumerFactory extends AbstractStatable
    implements JsonLogConsumerFactory
{
    public static final String NAME = "sherlock-templates";

    private static final String CLIENT_NAME = "index-client";

    private final IndexationClient indexClient;
    private final ImmutableHttpHostConfig indexHostConfig;
    private final SherlockTemplatesTskvParser parser;
    private final PrefixedLogger logger;
    private final TimeFrameQueue<Long> parseErrors;
    private final TimeFrameQueue<Long> mails;

    public SherlockTemplatesConsumerFactory(
        final SharedConnectingIOReactor reactor,
        final ImmutableBaseServerConfig serverConfig,
        final IniConfig config)
        throws ConfigException
    {
        this(reactor, serverConfig, new HttpHostConfigBuilder(config).build());
    }

    public SherlockTemplatesConsumerFactory(
        final SharedConnectingIOReactor reactor,
        final ImmutableBaseServerConfig serverConfig,
        final ImmutableHttpHostConfig config)
        throws ConfigException
    {
        indexHostConfig = config;

        indexClient =
            new IndexationClient(reactor, config)
                .adjustStater(
                    serverConfig.staters(),
                    new RequestInfo(
                        new BasicHttpRequest(
                            RequestHandlerMapper.GET,
                            "/sherlock/index/client")));
        logger =
            serverConfig.loggers().preparedLoggers().get(
                new RequestInfo(
                    new BasicHttpRequest(
                        RequestHandlerMapper.GET,
                        "/sherlock/templates")));
        parseErrors =
            new TimeFrameQueue<>(serverConfig.metricsTimeFrame());
        mails = new TimeFrameQueue<>(serverConfig.metricsTimeFrame());
        parser = new SherlockTemplatesTskvParser(logger, parseErrors, mails);

        registerStater(
            new PassiveStaterAdapter<>(
                parseErrors,
                new NamedStatsAggregatorFactory<>(
                    "sherlock-consumer-parse-error_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));

        registerStater(
            new PassiveStaterAdapter<>(
                mails,
                new NamedStatsAggregatorFactory<>(
                    "sherlock-consumer_mails_ammm",
                    IntegralSumAggregatorFactory.INSTANCE)));

        this.indexClient.start();
    }

    @Override
    public LogConsumer<JsonMap> create(
        final LogConfig config,
        final PrefixedLogger logger)
    {
        return new SherlockTemplatesConsumer(
            logger,
            indexClient,
            indexHostConfig,
            parser);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Map<String, Object> status(final boolean verbose) {
        Map<String, Object> status = new LinkedHashMap<>();
        status.put(CLIENT_NAME, indexClient.status(verbose));
        return status;
    }

    @Override
    public void close() throws IOException {
        indexClient.close();
    }
}
