package ru.yandex.logbroker.log.consumer.sherlock;

import java.util.function.Function;
import java.util.logging.Level;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.prefix.LongPrefix;

public class SherlockTemplatesTskvParser
    implements Function<JsonMap, MailTemplates>
{
    private static final int TID_SIZE = 21;
    private final PrefixedLogger logger;
    private final TimeFrameQueue<Long> parseErrors;
    private final TimeFrameQueue<Long> mails;

    public SherlockTemplatesTskvParser(
        final PrefixedLogger logger,
        final TimeFrameQueue<Long> parseErrors,
        final TimeFrameQueue<Long> mails)
    {
        this.logger = logger;
        this.parseErrors = parseErrors;
        this.mails = mails;
    }

    @Override
    public MailTemplates apply(final JsonMap record) {
        try {
            Long uid = record.getLong(MailIndexFields.UID);
            String stid = record.getString(MailIndexFields.STID);
            JsonList templates = record.getListOrNull("templates");
            if (templates == null) {
                templates = JsonList.EMPTY;
            }

            StringBuilder tids =
                new StringBuilder(templates.size() * TID_SIZE);

            for (JsonObject templateObj: templates) {
                Long tid =
                    templateObj.asMap().getLong(
                        "stable_sign",
                        null);
                if (tid != null) {
                    tids.append(tid);
                    tids.append('\n');
                }
            }

            if (stid != null
                && tids.length() > 0
                && !BlackboxUserinfo.corp(uid))
            {
                mails.accept(1L);
                tids.setLength(tids.length() - 1);
                return new MailTemplates(
                    new LongPrefix(uid),
                    stid,
                    tids.toString());
            }
        } catch (JsonException je) {
            parseErrors.accept(1L);
            logger.log(
                Level.WARNING,
                "Bad templates row",
                record.toString());
        }

        return null;
    }
}
