package ru.yandex.logbroker.server;

import java.io.IOException;
import java.util.Map;

import org.apache.http.message.BasicHttpRequest;

import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.logbroker.LogbrokerConsumer;
import ru.yandex.logbroker.config.ImmutableLogbrokerConsumerServerConfig;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.config.ConfigException;

public class LogbrokerConsumerServer
    extends HttpProxy<ImmutableLogbrokerConsumerServerConfig>
{
    private final LogbrokerConsumer logbrokerConsumer;

    private final PrefixedLogger consumerLogger;
    private final PrefixedLogger serverLogger;

    public LogbrokerConsumerServer(
        final ImmutableLogbrokerConsumerServerConfig config)
        throws IOException
    {
        super(config);

        consumerLogger =
            config.loggers().preparedLoggers().get(
                new RequestInfo(
                    new BasicHttpRequest(
                        RequestHandlerMapper.GET,
                        "/consumer")));
        serverLogger =
            config.loggers().preparedLoggers().get(
                new RequestInfo(
                    new BasicHttpRequest(
                        RequestHandlerMapper.GET,
                        "/server")));
        try {
            logbrokerConsumer =
                new LogbrokerConsumer(reactor, config, consumerLogger);
        } catch (ConfigException ce) {
            throw new IOException(ce);
        }
        registerStater(logbrokerConsumer);
    }

    @Override
    public void start() throws IOException {
        super.start();

        this.logbrokerConsumer.start();
    }

    @Override
    public void close() throws IOException {
        this.logbrokerConsumer.close();

        super.close();
    }

    @Override
    public PrefixedLogger logger() {
        if (serverLogger != null) {
            return serverLogger;
        }

        return super.logger();
    }

    @Override
    public Map<String, Object> status(final boolean verbose) {
        Map<String, Object> status = super.status(verbose);
        status.putAll(this.logbrokerConsumer.status(verbose));
        return status;
    }
}
