package ru.yandex.logbroker.topic;

import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;

import ru.yandex.tskv.BasicTskvParser;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvRecord;

public class ChunkTskvParser extends BasicTskvParser {
    private final Charset charset;

    private TskvRecord record;

    public ChunkTskvParser(final Charset charset) {
        super(null);

        this.charset = charset;
    }

    public TskvRecord parse(
        final byte[] data,
        final int offset,
        final int length)
        throws IOException
    {
        parse(new StringReader(new String(data, offset, length, charset)));
        return record;
    }

    @Override
    protected boolean handle(final TskvRecord record) throws TskvException {
        this.record = record;
        return false;
    }
}
