package ru.yandex.logbroker.topic;

import java.io.InputStream;
import java.nio.charset.Charset;

import ru.yandex.tskv.TskvRecord;

public class DataChunk {
    private final long offset;
    private final long writeTime;
    private final long readTime;
    private final long size;
    private final long fetchTime;
    private final String partition;
    private final String codec;
    private final InputStream data;
    private final Charset charset;
    private final TskvRecord header;

    //CSOFF: ParameterNumber
    public DataChunk(
        final TskvRecord record,
        final String partition,
        final Charset charset,
        final InputStream data)
        throws NumberFormatException
    {
        this.header = record;
        this.offset = Long.parseLong(record.get("offset"));
        this.writeTime = Long.parseLong(record.get("wtime"));
        this.readTime = Long.parseLong(record.get("ctime"));
        this.size = Long.parseLong(record.get("size"));
        this.codec = record.get("codec");
        this.partition = partition;
        this.charset = charset;
        this.data = data;
        this.fetchTime = System.currentTimeMillis();
    }
    //CSON: ParameterNumber

    public long offset() {
        return offset;
    }

    public InputStream data() {
        return data;
    }

    public String partition() {
        return partition;
    }

    public long writeTime() {
        return writeTime;
    }

    public long createTime() {
        return readTime;
    }

    public String codec() {
        return codec;
    }

    public Charset charset() {
        return charset;
    }

    public long size() {
        return size;
    }

    public TskvRecord header() {
        return header;
    }

    public long fetchTime() {
        return fetchTime;
    }

    public String toShortInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataChunk Partition: ");
        sb.append(partition);
        sb.append(" Offset ");
        sb.append(offset);
        return sb.toString();
    }
}
