package ru.yandex.logbroker.topic;

import java.io.IOException;

import ru.yandex.logbroker.client.Partition;
import ru.yandex.logbroker.client.ReadSession;
import ru.yandex.logbroker.config.ImmutableTopicConfig;

public class SupportPartitionWorker extends PartitionWorker {
    public SupportPartitionWorker(
        final ImmutableTopicConfig topicConfig,
        final Partition partition,
        final ReadMetrics readMetrics)
    {
        super(topicConfig, partition, readMetrics);
    }

    @Override
    protected String prefix() {
        return "SupportWorker";
    }

    @Override
    protected DataChunk fetchChunk(
        final ReadSession session)
        throws IOException
    {
        DataChunk chunk = super.fetchChunk(session);
        if (chunk == null) {
            stop();
        }

        return chunk;
    }
}
