package ru.yandex.logger;

import java.util.Map;

public class AccessLoggerConfigDefaults
    extends LoggerFileConfigDefaults
    implements LoggerConfigInterfaceDefaults
{
    public static final AccessLoggerConfigDefaults INSTANCE =
        new AccessLoggerConfigDefaults();

    protected AccessLoggerConfigDefaults() {
    }

    @Override
    public String dateFormat() {
        return "dd/MMM/yyyy:HH:mm:ss Z";
    }

    @Override
    public String logFormat() {
        return "%{remote_addr} - %{user} [%{date}] \"%{request}\" %{status} "
            + "%{response_length} %{request_time} %{session_id}";
    }

    @Override
    public Map<String, ? extends LoggerFileConfig> files() {
        return LoggerConfigDefaults.defaultsFor(this);
    }
}

