package ru.yandex.logger;

import java.util.logging.LogRecord;

import ru.yandex.parser.config.ConfigException;

public class AsyncCustomFormatter extends SBFormatter {
    private static final ThreadAppenderFactory THREAD_APPENDER_FACTORY =
        new ThreadAppenderFactory() {
            @Override
            public ResourceBundleNameAppender create() {
                return new ResourceBundleNameAppender();
            }
        };

    private final FormatterContext context;

    public AsyncCustomFormatter(
        final ImmutableLoggerConfig loggerConfig,
        final ImmutableLoggerFileConfig config)
        throws ConfigException
    {
        context = new FormatterContext(
            config.outputFormat().parse(
                loggerConfig,
                config,
                THREAD_APPENDER_FACTORY));
    }

    @Override
    public StringBuilder formatSB(final LogRecord record) {
        return context.format(record);
    }
}

