package ru.yandex.logger;

import java.io.FileNotFoundException;

public class AsyncNumberingRotatableFileHandler
    extends AsyncRotatableFileHandler
{
    public AsyncNumberingRotatableFileHandler(
        final ImmutableLoggerFileConfig config)
        throws FileNotFoundException
    {
        super(config);
    }

    @Override
    public synchronized void rotate() throws FileNotFoundException {
        if (!file().exists()
            || NumberingRotatableFileHandler.rename(file(), file(), 0))
        {
            super.rotate();
        }
    }
}
