package ru.yandex.logger;

import java.io.File;
import java.io.FileNotFoundException;

public class AsyncRotatableFileHandler
    extends AsyncStreamHandler
    implements RotatableHandler
{
    private final File file;

    public AsyncRotatableFileHandler(final ImmutableLoggerFileConfig config)
        throws FileNotFoundException
    {
        super(config);
        this.file = config.file();
    }

    @Override
    public void rotate() throws FileNotFoundException {
        setOutputStream(createStream(file));
    }

    protected File file() {
        return file;
    }
}
