package ru.yandex.logger;

import java.util.logging.LogRecord;

import ru.yandex.parser.config.ConfigException;

public class CustomFormatter extends SBFormatter {
    private static final ThreadAppenderFactory THREAD_APPENDER_FACTORY =
        new ThreadAppenderFactory() {
            @Override
            public ThreadAppender create() {
                return new ThreadAppender();
            }
        };

    private final ThreadLocalFormatterContext context;

    public CustomFormatter(
        final ImmutableLoggerConfig loggerConfig,
        final ImmutableLoggerFileConfig config)
        throws ConfigException
    {
        context = new ThreadLocalFormatterContext(
            config.outputFormat().parse(
                loggerConfig,
                config,
                THREAD_APPENDER_FACTORY));
    }

    @Override
    public StringBuilder formatSB(final LogRecord record) {
        return context.get().format(record);
    }
}

