package ru.yandex.logger;

import java.util.logging.LogRecord;

import org.joda.time.format.DateTimeFormatter;

public class DateAppender implements LogAppender {
    private final DateTimeFormatter formatter;

    public DateAppender(final DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public DateAppender copy() {
        return this;
    }

    @Override
    public void append(final StringBuilder sb, final LogRecord record) {
        formatter.printTo(sb, record.getMillis());
    }
}

