package ru.yandex.logger;

import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DevNullLogger extends PrefixedLogger {
    public static final DevNullLogger INSTANCE = new DevNullLogger();

    public static final Filter FALSE_FILTER = record -> false;

    public static final Handler[] EMPTY_HANDLERS = new Handler[0];

    protected DevNullLogger() {
        super(Logger.getAnonymousLogger(), "", "");
    }

    // PrefixedLogger implementation
    @Override
    public String separator() {
        return "";
    }

    @Override
    public DevNullLogger addPrefix(final String prefix) {
        return this;
    }

    @Override
    public DevNullLogger replacePrefix(final String prefix) {
        return this;
    }

    // Logger implementation
    @Override
    public void addHandler(final Handler handler) {
    }

    @Override
    public void config(final String msg) {
    }

    @Override
    public void config(final Supplier<String> msgSupplier) {
    }

    @Override
    public void entering(final String sourceClass, final String sourceMethod) {
    }

    @Override
    public void entering(
        final String sourceClass,
        final String sourceMethod,
        final Object param)
    {
    }

    @Override
    public void entering(
        final String sourceClass,
        final String sourceMethod,
        final Object[] params)
    {
    }

    @Override
    public void exiting(final String sourceClass, final String sourceMethod) {
    }

    @Override
    public void exiting(
        final String sourceClass,
        final String sourceMethod,
        final Object result)
    {
    }

    @Override
    public void fine(final String msg) {
    }

    @Override
    public void fine(final Supplier<String> msgSupplier) {
    }

    @Override
    public void finer(final String msg) {
    }

    @Override
    public void finer(final Supplier<String> msgSupplier) {
    }

    @Override
    public void finest(final String msg) {
    }

    @Override
    public void finest(final Supplier<String> msgSupplier) {
    }

    @Override
    public Filter getFilter() {
        return FALSE_FILTER;
    }

    @Override
    public Handler[] getHandlers() {
        return EMPTY_HANDLERS;
    }

    @Override
    public Level getLevel() {
        return Level.OFF;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Logger getParent() {
        return null;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return null;
    }

    @Override
    public String getResourceBundleName() {
        return "";
    }

    @Override
    public boolean getUseParentHandlers() {
        return false;
    }

    @Override
    public void info(final String msg) {
    }

    @Override
    public void info(final Supplier<String> msgSupplier) {
    }

    @Override
    public boolean isLoggable(final Level level) {
        return false;
    }

    @Override
    public void log(final Level level, final String msg) {
    }

    @Override
    public void log(final Level level, final String msg, final Object param) {
    }

    @Override
    public void log(
        final Level level,
        final String msg,
        final Object[] params)
    {
    }

    @Override
    public void log(
        final Level level,
        final String msg,
        final Throwable thrown)
    {
    }

    @Override
    public void log(
        final Level level,
        final Throwable thrown,
        final Supplier<String> msgSupplier)
    {
    }

    @Override
    public void log(final Level level, final Supplier<String> msgSupplier) {
    }

    @Override
    public void log(final LogRecord record) {
    }

    // CSOFF: ParameterNumber
    @Override
    public void logp(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final String msg)
    {
    }

    @Override
    public void logp(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final String msg,
        final Object param)
    {
    }

    @Override
    public void logp(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final String msg,
        final Object[] params)
    {
    }

    @Override
    public void logp(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final String msg,
        final Throwable thrown)
    {
    }

    @Override
    public void logp(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final Throwable thrown,
        final Supplier<String> msgSupplier)
    {
    }

    @Override
    public void logp(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final Supplier<String> msgSupplier)
    {
    }

    @Override
    public void logrb(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final ResourceBundle bundle,
        final String msg,
        final Object... params)
    {
    }

    @Override
    public void logrb(
        final Level level,
        final String sourceClass,
        final String sourceMethod,
        final ResourceBundle bundle,
        final String msg,
        final Throwable thrown)
    {
    }
    // CSON: ParameterNumber

    @Override
    public void removeHandler(final Handler handler) {
    }

    @Override
    public void setFilter(final Filter filter) {
    }

    @Override
    public void setLevel(final Level level) {
    }

    @Override
    public void setParent(final Logger logger) {
    }

    @Override
    public void setResourceBundle(final ResourceBundle bundle) {
    }

    @Override
    public void setUseParentHandlers(final boolean useParentHandlers) {
    }

    @Override
    public void severe(final String msg) {
    }

    @Override
    public void severe(final Supplier<String> msgSupplier) {
    }

    @Override
    public void throwing(
        final String sourceClass,
        final String sourceMethod,
        final Throwable thrown)
    {
    }

    @Override
    public void warning(final String msg) {
    }

    @Override
    public void warning(final Supplier<String> msgSupplier) {
    }
}

