package ru.yandex.logger;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Handler;

public enum FileRotateType {
    NONE {
        @Override
        public Handler createHandler(final ImmutableLoggerFileConfig config)
            throws FileNotFoundException
        {
            if (config.queueLength() == 0) {
                return new StreamHandler(
                    new FileOutputStream(config.file(), true));
            } else {
                return new AsyncStreamHandler(config).start();
            }
        }
    },
    REOPEN {
        @Override
        public Handler createHandler(final ImmutableLoggerFileConfig config)
            throws FileNotFoundException
        {
            if (config.queueLength() == 0) {
                return new RotatableFileHandler(config.file());
            } else {
                return new AsyncRotatableFileHandler(config).start();
            }
        }
    },
    NUMBER {
        @Override
        public Handler createHandler(final ImmutableLoggerFileConfig config)
            throws FileNotFoundException
        {
            if (config.queueLength() == 0) {
                return new NumberingRotatableFileHandler(config.file());
            } else {
                return new AsyncNumberingRotatableFileHandler(config).start();
            }
        }
    };
    public abstract Handler createHandler(
        final ImmutableLoggerFileConfig config)
        throws FileNotFoundException;
}
