package ru.yandex.logger;

import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FilterLogger extends Logger {
    protected final Logger logger;

    public FilterLogger(final Logger logger) {
        super(logger.getName(), logger.getResourceBundleName());
        super.setLevel(logger.getLevel());
        this.logger = logger;
    }

    @Override
    public void addHandler(final Handler handler) {
        logger.addHandler(handler);
    }

    @Override
    public Filter getFilter() {
        return logger.getFilter();
    }

    @Override
    public Handler[] getHandlers() {
        return logger.getHandlers();
    }

    @Override
    public Level getLevel() {
        return logger.getLevel();
    }

    @Override
    public String getName() {
        return logger.getName();
    }

    @Override
    public Logger getParent() {
        return logger.getParent();
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return logger.getResourceBundle();
    }

    @Override
    public String getResourceBundleName() {
        return logger.getResourceBundleName();
    }

    @Override
    public boolean getUseParentHandlers() {
        return logger.getUseParentHandlers();
    }

    @Override
    public boolean isLoggable(final Level level) {
        return logger.isLoggable(level);
    }

    @Override
    public void log(final LogRecord record) {
        logger.log(record);
    }

    @Override
    public void removeHandler(final Handler handler) {
        logger.removeHandler(handler);
    }

    @Override
    public void setFilter(final Filter filter) {
        logger.setFilter(filter);
    }

    @Override
    public void setLevel(final Level level) {
        super.setLevel(level);
        logger.setLevel(level);
    }

    @Override
    public void setParent(final Logger parent) {
        logger.setParent(parent);
    }

    @Override
    public void setUseParentHandlers(final boolean useParentHandlers) {
        logger.setUseParentHandlers(useParentHandlers);
    }
}

