package ru.yandex.logger;

import java.util.List;

import ru.yandex.logger.json.JsonFormatContextBuilder;
import ru.yandex.parser.config.ConfigException;

public enum FormatParser {
    PLAIN {
        @Override
        protected FormatterContextBuilder visitor(
            final ImmutableLoggerConfig loggerConfig,
            final ImmutableLoggerFileConfig fileConfig,
            final ThreadAppenderFactory threadAppenderFactory)
            throws ConfigException
        {
            return new PlainFormatContextBuilder(
                loggerConfig,
                fileConfig,
                threadAppenderFactory);
        }
    },
    JSON {
        @Override
        protected FormatterContextBuilder visitor(
            final ImmutableLoggerConfig loggerConfig,
            final ImmutableLoggerFileConfig fileConfig,
            final ThreadAppenderFactory threadAppenderFactory)
            throws ConfigException
        {
            return new JsonFormatContextBuilder(
                loggerConfig,
                fileConfig,
                threadAppenderFactory);
        }
    };

    private static final int MIN_STRING = 3;

    protected abstract FormatterContextBuilder visitor(
        final ImmutableLoggerConfig loggerConfig,
        final ImmutableLoggerFileConfig fileConfig,
        final ThreadAppenderFactory threadAppenderFactory)
        throws ConfigException;

    public List<LogAppender> parse(
        final ImmutableLoggerConfig loggerConfig,
        final ImmutableLoggerFileConfig fileConfig,
        final ThreadAppenderFactory threadAppenderFactory)
        throws ConfigException
    {
        FormatterContextBuilder visitor =
            visitor(loggerConfig, fileConfig, threadAppenderFactory);

        String format = fileConfig.logFormat();
        int pos = 0;
        while (pos < format.length()) {
            int next = format.indexOf("%{", pos);
            int end = -1;
            if (next == -1) {
                next = format.length();
            } else {
                end = format.indexOf('}', next + 2);
                if (end == -1) {
                    next = format.length();
                }
            }
            int len = next - pos;
            if (len > MIN_STRING) {
                visitor.visitString(format.substring(pos, next));
            } else {
                while (pos < next) {
                    visitor.visit(format.charAt(pos++));
                }
            }
            if (end != -1) {
                String placeholder = format.substring(next + 2, end);
                next = end + 1;
                visitor.visitPlaceholder(placeholder);
            }
            pos = next;
        }

        return visitor.build();
    }
}

