package ru.yandex.logger;

import java.util.List;
import java.util.logging.LogRecord;

public class FormatterContext {
    private final StringBuilder sb = new StringBuilder(4096);
    private final LogAppender[] appenders;

    public FormatterContext(final List<LogAppender> appenders) {
        this.appenders = appenders.toArray(new LogAppender[appenders.size()]);
    }

    public StringBuilder format(final LogRecord record) {
        sb.setLength(0);
        for (LogAppender appender: appenders) {
            appender.append(sb, record);
        }
        sb.append('\n');
        return sb;
    }
}

