package ru.yandex.logger;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import ru.yandex.parser.config.ConfigException;

public class ImmutableLoggerFileConfig implements LoggerFileConfig {
    private final File file;
    private final FileRotateType rotate;
    private final String dateFormat;
    private final Locale dateLocale;
    private final String logFormat;
    private final FormatParser outputFormat;
    private final int queueLength;
    private final int memoryLimit;
    private final int fsyncThreshold;

    public ImmutableLoggerFileConfig(final LoggerFileConfig config)
        throws ConfigException
    {
        if (config.file() == null) {
            file = null;
        } else {
            try {
                file = config.file().getCanonicalFile();
            } catch (IOException e) {
                throw new ConfigException(
                    "Failed to resolve canonical file name for: "
                    + config.file(),
                    e);
            }
        }
        outputFormat = config.outputFormat();
        rotate = config.rotate();
        dateFormat = config.dateFormat();
        dateLocale = config.dateLocale();
        logFormat = config.logFormat();
        queueLength = config.queueLength();
        memoryLimit = config.memoryLimit();
        fsyncThreshold = config.fsyncThreshold();
    }

    @Override
    public File file() {
        return file;
    }

    @Override
    public FileRotateType rotate() {
        return rotate;
    }

    @Override
    public String dateFormat() {
        return dateFormat;
    }

    @Override
    public Locale dateLocale() {
        return dateLocale;
    }

    @Override
    public String logFormat() {
        return logFormat;
    }

    @Override
    public int queueLength() {
        return queueLength;
    }

    @Override
    public int memoryLimit() {
        return memoryLimit;
    }

    @Override
    public int fsyncThreshold() {
        return fsyncThreshold;
    }

    @Override
    public String toString() {
        return toList().toString();
    }

    @Override
    public int hashCode() {
        return toList().hashCode();
    }

    @Override
    public FormatParser outputFormat() {
        return outputFormat;
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof ImmutableLoggerFileConfig) {
            return toList().equals(((ImmutableLoggerFileConfig) o).toList());
        }
        return false;
    }

    public List<Object> toList() {
        return Arrays.asList(
            file,
            rotate,
            dateFormat,
            dateLocale,
            logFormat,
            queueLength,
            memoryLimit,
            fsyncThreshold);
    }
}

