package ru.yandex.logger;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class LoggerConfigBuilder
     extends AbstractLoggerConfigBuilder<LoggerConfigBuilder>
{
    public LoggerConfigBuilder() {
        this(LoggerConfigDefaults.INSTANCE);
    }

    public LoggerConfigBuilder(final LoggerConfig config) {
        super(config);
    }

    public LoggerConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, LoggerConfigDefaults.INSTANCE);
    }

    public LoggerConfigBuilder(
        final IniConfig config,
        final LoggerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public LoggerConfigBuilder(
        final IniConfig config,
        final LoggerConfig defaults,
        final LoggerFileConfig defaultFileConfig)
        throws ConfigException
    {
        super(config, defaults, defaultFileConfig);
    }

    public ImmutableLoggerConfig build() throws ConfigException {
        return new ImmutableLoggerConfig(this);
    }

    @Override
    public LoggerConfigBuilder self() {
        return this;
    }
}
