package ru.yandex.logger;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

import ru.yandex.logger.json.YtLoggerFileConfigDefaults;

public class LoggerConfigDefaults
     implements LoggerConfig
{
    public static final LoggerConfigDefaults INSTANCE =
        new LoggerConfigDefaults();

    public static final Map<String, LoggerFileConfig> DEFAULT_CONFIGS;

    private static final Map<String, LoggerFileConfig> DEFAULTS =
            Collections.singletonMap(DEFAULT, LoggerFileConfigDefaults.INSTANCE);

    static {
        Map<String, LoggerFileConfig> map = new LinkedHashMap<>();
        map.put(DEFAULT, LoggerFileConfigDefaults.INSTANCE);
        map.put(YT, YtLoggerFileConfigDefaults.INSTANCE);

        DEFAULT_CONFIGS = Collections.unmodifiableMap(map);
    }

    protected LoggerConfigDefaults() {
    }

    @Override
    public Map<String, ? extends LoggerFileConfig> files() {
        return DEFAULTS;
    }

    public static Map<String, ? extends LoggerFileConfig> defaultsFor(
        final LoggerFileConfig config)
    {
        return Collections.singletonMap(DEFAULT, config);
    }

    @Override
    public String separator() {
        return "\t";
    }

    @Override
    public Level logLevel() {
        return Level.ALL;
    }

    @Override
    public Charset charset() {
        return StandardCharsets.UTF_8;
    }
}
