package ru.yandex.logger;

import java.io.File;
import java.util.Locale;

public class LoggerFileConfigDefaults implements LoggerFileConfig {
    public static final LoggerFileConfigDefaults INSTANCE =
        new LoggerFileConfigDefaults();

    @Override
    public File file() {
        return null;
    }

    @Override
    public FileRotateType rotate() {
        return FileRotateType.REOPEN;
    }

    @Override
    public String dateFormat() {
        return "yyyy-MM-dd HH:mm:ss.SSS";
    }

    @Override
    public Locale dateLocale() {
        return Locale.US;
    }

    @Override
    public String logFormat() {
        return "%{date}%{separator}%{level}%{separator}%{thread}%{separator}"
            + "%{message}";
    }

    @Override
    public FormatParser outputFormat() {
        return FormatParser.PLAIN;
    }

    @Override
    public int queueLength() {
        return 0;
    }

    @Override
    public int memoryLimit() {
        return 0;
    }

    @Override
    public int fsyncThreshold() {
        return 0;
    }
}

