package ru.yandex.logger;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Logger;

import ru.yandex.charset.Decoder;

public class LoggerOutputStream extends ByteArrayOutputStream {
    private final Logger logger;
    private final Decoder decoder;

    public LoggerOutputStream(final Logger logger, final Charset charset) {
        this.logger = logger;
        decoder = new Decoder(charset);
    }

    @Override
    public void flush() throws IOException {
        final String message;
        synchronized (this) {
            super.flush();
            decoder.decode(toByteArray());
            reset();
            message = decoder.toString();
        }
        if (!message.trim().isEmpty()) {
            logger.info(message);
        }
    }
}

