package ru.yandex.logger;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.util.request.RequestInfo;

public class LoggersConfigDefaults implements LoggersConfig {
    public static final LoggersConfigDefaults INSTANCE =
        new LoggersConfigDefaults();

    protected LoggersConfigDefaults() {
    }

    @Override
    public LoggerConfig stdout() {
        return null;
    }

    @Override
    public LoggerConfig stderr() {
        return null;
    }

    @Override
    public PatternMap<RequestInfo, ? extends LoggerConfig> loggers() {
        return new PatternMap<>(LoggerConfigDefaults.INSTANCE);
    }

    @Override
    public PatternMap<RequestInfo, ? extends LoggerConfig> accessLoggers() {
        return new PatternMap<>(AccessLoggerConfigDefaults.INSTANCE);
    }
}

