package ru.yandex.logger;

import java.util.logging.LogRecord;

import ru.yandex.io.StringBuilderWriter;

public class MessageAppender implements LogAppender {
    @Override
    public MessageAppender copy() {
        return this;
    }

    @Override
    public void append(final StringBuilder sb, final LogRecord record) {
        sb.append(record.getMessage());
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            sb.append(':');
            sb.append(' ');
            thrown.printStackTrace(new StringBuilderWriter(sb));
        }
    }
}

