package ru.yandex.logger;

import java.io.File;
import java.io.FileNotFoundException;

public class NumberingRotatableFileHandler extends RotatableFileHandler {
    private static final String GZIP_EXT = ".gz";

    public NumberingRotatableFileHandler(final File file)
        throws FileNotFoundException
    {
        super(file);
    }

    public static boolean rename(
        final File origFile,
        final File file,
        final int level)
    {
        File gzNext = new File(origFile.getAbsolutePath() + '.' + level
            + GZIP_EXT);

        File next = new File(origFile.getAbsolutePath() + '.' + level);

        if (next.exists() || gzNext.exists()) {
            if (!rename(origFile, next, level + 1)) {
                return false;
            }
        }

        boolean success = true;
        File gzFile = new File(origFile.getAbsolutePath() + GZIP_EXT);
        if (file.exists()) {
            success = file.renameTo(next);
        }
        if (gzFile.exists() && success) {
            success = gzFile.renameTo(gzNext);
        }
        return success;
    }

    @Override
    public synchronized void rotate() throws FileNotFoundException {
        if (!file().exists() || rename(file(), file(), 0)) {
            super.rotate();
        }
    }
}

