package ru.yandex.logger;

import java.util.logging.LogRecord;

public class ParamAppender implements LogAppender {
    private final String name;

    public ParamAppender(final String name) {
        this.name = name;
    }

    @Override
    public ParamAppender copy() {
        return this;
    }

    @Override
    public void append(final StringBuilder sb, final LogRecord record) {
        Object[] params = record.getParameters();
        String str = null;
        if (params != null
            && params.length != 0
            && params[0] instanceof Lookup)
        {
            Object value = ((Lookup<?>) params[0]).lookup(name);
            if (value != null) {
                str = value.toString();
            }
        }
        if (str == null) {
            sb.append('-');
        } else {
            sb.append(str);
        }
    }
}

