package ru.yandex.logger;

import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PrefixedLogger extends FilterLogger {
    private final String prefix;
    private final String separator;

    public PrefixedLogger(
        final Logger logger,
        final String prefix,
        final String separator)
    {
        super(logger);
        if (prefix.isEmpty()) {
            this.prefix = prefix;
        } else {
            this.prefix = prefix + separator;
        }
        this.separator = separator;
    }

    public String separator() {
        return separator;
    }

    public PrefixedLogger addPrefix(final String prefix) {
        return new PrefixedLogger(this, prefix, separator);
    }

    public PrefixedLogger replacePrefix(final String prefix) {
        return new PrefixedLogger(logger, prefix, separator);
    }

    @Override
    public void log(final LogRecord record) {
        record.setMessage(prefix + record.getMessage());
        super.log(record);
    }
}

