package ru.yandex.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class RotatableFileHandler
    extends StreamHandler
    implements RotatableHandler
{
    private final File file;

    public RotatableFileHandler(final File file)
        throws FileNotFoundException
    {
        super(createStream(file));
        this.file = file;
    }

    private static OutputStream createStream(final File file)
        throws FileNotFoundException
    {
        return new FileOutputStream(file, true);
    }

    @Override
    public void rotate() throws FileNotFoundException {
        setOutputStream(createStream(file));
    }

    protected File file() {
        return file;
    }
}

