package ru.yandex.logger;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public final class SBFormatterAdapter extends SBFormatter {
    private final StringBuilder sb = new StringBuilder();
    private final Formatter formatter;

    private SBFormatterAdapter(final Formatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public StringBuilder formatSB(final LogRecord record) {
        sb.setLength(0);
        sb.append(formatter.format(record));
        return sb;
    }

    @Override
    public String format(final LogRecord record) {
        return formatter.format(record);
    }

    @Override
    synchronized public String formatMessage(final LogRecord record) {
        return formatter.formatMessage(record);
    }

    @Override
    public String getHead(final Handler h) {
        return formatter.getHead(h);
    }

    @Override
    public String getTail(final Handler h) {
        return formatter.getTail(h);
    }

    public static SBFormatter adapt(final Formatter formatter) {
        if (formatter instanceof SBFormatter) {
            return (SBFormatter) formatter;
        } else {
            return new SBFormatterAdapter(formatter);
        }
    }
}

