package ru.yandex.logger;

import java.util.Map;

public class StdoutLoggerConfigDefaults
    extends LoggerFileConfigDefaults
    implements LoggerConfigInterfaceDefaults
{
    public static final StdoutLoggerConfigDefaults INSTANCE =
        new StdoutLoggerConfigDefaults();

    protected StdoutLoggerConfigDefaults() {
    }

    @Override
    public String dateFormat() {
        return "yyyy-MM-dd HH:mm:ss.SSS";
    }

    @Override
    public String logFormat() {
        return "%{date}%{separator}%{thread}%{separator}%{message}";
    }

    @Override
    public Map<String, ? extends LoggerFileConfig> files() {
        return LoggerConfigDefaults.defaultsFor(this);
    }
}

