package ru.yandex.logger;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;

public abstract class StreamHandlerBase extends Handler {
    protected volatile SBFormatter formatter = null;
    private Level level;

    protected StreamHandlerBase() {
        level = super.getLevel();
    }

    @Override
    @SuppressWarnings("UnsynchronizedOverridesSynchronized")
    public void setLevel(final Level newLevel) {
        super.setLevel(newLevel);
        level = newLevel;
    }

    @Override
    public Level getLevel() {
        return level;
    }

    @Override
    @SuppressWarnings("UnsynchronizedOverridesSynchronized")
    public void setFormatter(final Formatter formatter) {
        this.formatter = SBFormatterAdapter.adapt(formatter);
        super.setFormatter(this.formatter);
    }
}

