package ru.yandex.logger;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;

public final class SystemErrManager {
    private SystemErrManager() {
    }

    private static PrintStream originalErr;
    private static int refs = 0;

    public static synchronized void setErr(final Logger logger) {
        if (refs++ == 0) {
            originalErr = System.err;
            System.setErr(new ErrorLogger(logger).printStream());
        }
    }

    public static synchronized void unsetErr() {
        if (--refs == 0) {
            System.setErr(originalErr);
        }
    }

    private static class ErrorLogger extends ByteArrayOutputStream {
        private final Logger logger;
        private final PrintStream printStream;

        public ErrorLogger(final Logger logger) {
            this.logger = logger;
            printStream = new PrintStream(this, true);
        }

        @Override
        public synchronized void flush() throws IOException {
            super.flush();
            String record = toString().trim();
            reset();

            if (record.isEmpty()) {
                // avoid empty records
                return;
            }
            logger.info(record);
        }

        public PrintStream printStream() {
            return printStream;
        }
    }
}

