package ru.yandex.logger;

import java.util.ArrayList;
import java.util.List;

public class ThreadLocalFormatterContext
    extends ThreadLocal<FormatterContext>
{
    private final List<LogAppender> appenders;

    public ThreadLocalFormatterContext(final List<LogAppender> appenders) {
        this.appenders = appenders;
    }

    @Override
    public FormatterContext initialValue() {
        List<LogAppender> appenders = new ArrayList<>(this.appenders.size());
        for (LogAppender appender: this.appenders) {
            appenders.add(appender.copy());
        }
        return new FormatterContext(appenders);
    }
}

