package ru.yandex.logger.json;

import java.io.IOException;
import java.util.logging.LogRecord;

import org.joda.time.format.DateTimeFormatter;

import ru.yandex.json.writer.JsonWriter;

public class DateJsonLogAppender implements JsonLogAppender {
    private final DateTimeFormatter formatter;

    public DateJsonLogAppender(final DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public void append(
        final JsonWriter writer,
        final LogRecord record)
        throws IOException
    {
        writer.key(JsonLogFields.DATE.printName());
        writer.value(formatter.print(record.getMillis()));
    }
}
