package ru.yandex.logger.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;

import ru.yandex.json.writer.JsonWriter;

public class JsonEnvsLogAppender implements JsonLogAppender {
    private final String[] values;
    private final String[] printNames;
    private final Map<String, String> envNamePrintNamePairs;

    public JsonEnvsLogAppender(
        final Map<String, String> envNamePrintNamePairs)
    {
        this.envNamePrintNamePairs = envNamePrintNamePairs;

        List<String> values = new ArrayList<>();
        List<String> names = new ArrayList<>();

        for (Map.Entry<String, String> entry
            : envNamePrintNamePairs.entrySet())
        {
            String value = System.getenv(entry.getKey());
            if (value != null) {
                names.add(entry.getValue());
                values.add(value);
            }
        }

        this.values = values.toArray(new String[values.size()]);
        this.printNames = names.toArray(new String[names.size()]);
    }

    @Override
    public JsonLogAppender copy() {
        return new JsonEnvsLogAppender(envNamePrintNamePairs);
    }

    @Override
    public void append(
        final JsonWriter writer,
        final LogRecord record)
        throws IOException
    {
        for (int i = 0; i < printNames.length; i++) {
            writer.key(printNames[i]);
            writer.value(values[i]);
        }
    }
}
