package ru.yandex.logger.json;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.LogRecord;

import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.Lookup;

public class JsonParamsLogAppender implements JsonLogAppender {
    private final String[] names;

    public JsonParamsLogAppender(final Collection<String> names) {
        this.names = names.toArray(new String[names.size()]);
    }

    public JsonParamsLogAppender(final String[] names) {
        this.names = Arrays.copyOf(names, names.length);
    }

    @Override
    public JsonParamsLogAppender copy() {
        return new JsonParamsLogAppender(names);
    }

    @Override
    public void append(
        final JsonWriter writer,
        final LogRecord record)
        throws IOException
    {
        Object[] params = record.getParameters();
        if (params != null
            && params.length != 0
            && params[0] instanceof Lookup)
        {
            Lookup<?> lookupable = (Lookup<?>) params[0];
            for (String name: names) {
                Object value = lookupable.lookup(name);
                if (value != null) {
                    writer.key(name);
                    writer.value(value);
                }
            }
        }
    }
}
