package ru.yandex.logger.json;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.LogRecord;

import ru.yandex.io.UnsafeStringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.LogAppender;

public class JsonWriterAppender implements LogAppender {
    // We rely on thread safe of appender
    private final UnsafeStringBuilderWriter builderWrapper
        = new UnsafeStringBuilderWriter();
    private final JsonWriter writer = JsonType.NORMAL.create(builderWrapper);

    private final JsonLogAppender[] appenders;

    public JsonWriterAppender(final Collection<JsonLogAppender> appenders) {
        this.appenders =
            appenders.toArray(new JsonLogAppender[appenders.size()]);
    }

    public JsonWriterAppender(final JsonLogAppender[] appenders) {
        this.appenders = Arrays.copyOf(appenders, appenders.length);
    }

    @Override
    public LogAppender copy() {
        JsonLogAppender[] appenders =
            new JsonLogAppender[this.appenders.length];

        for (int i = 0; i < appenders.length; i++) {
            appenders[i] = this.appenders[i].copy();
        }

        return new JsonWriterAppender(appenders);
    }

    @Override
    public void append(
        final StringBuilder sb,
        final LogRecord record)
    {
        builderWrapper.sb(sb);
        writer.reset();

        try {
            writer.startObject();
            for (JsonLogAppender appender: appenders) {
                appender.append(writer, record);
            }
            writer.endObject();
            // validate state
            writer.close();
        } catch (IOException ioe) {
            sb.append(
                "{\"message\":\"logrecord transformed to invalid json\"}");
        }
    }
}
