package ru.yandex.mulcagate;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.protocol.HttpContext;

import ru.yandex.function.CharArrayProcessable;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.nio.AbstractAsyncCharArrayConsumer;
import ru.yandex.parser.string.CollectionParser;

public class PrimaryDistInfoConsumer
    extends AbstractAsyncCharArrayConsumer<List<StorageHost>>
{
    private static final CollectionParser<
        String,
        List<String>,
        RuntimeException>
            PARSER = new CollectionParser<>(x -> x, ArrayList::new, '\n');

    public static List<StorageHost> parseHosts(final CharArrayProcessable data)
        throws MulcagateException, NotFoundException
    {
        List<StorageHost> hosts;
        boolean hasPrimary = false;
        try {
            List<String> hostStrings = data.processWith(PARSER);
            hosts = new ArrayList<>(hostStrings.size());
            for (String hostString: hostStrings) {
                if (!hostString.isEmpty()) {
                    StorageHost host = new StorageHost(hostString);
                    hosts.add(host);
                    if (host.primary()) {
                        hasPrimary = true;
                    }
                }
            }
        } catch (MulcagateException e) {
            throw e;
        } catch (Throwable t) {
            throw new MulcagateMalformedHostException(
                "Failed to parse response: '" + data + '\'',
                t);
        }
        if (!hasPrimary) {
            throw new NotFoundException("Not primary hosts found for stid");
        }
        return hosts;
    }

    @Override
    public List<StorageHost> buildResult(
        final CharArrayProcessable data,
        final HttpContext context)
        throws MulcagateException, NotFoundException
    {
        return parseHosts(data);
    }
}

