package ru.yandex.multistarter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public final class MultiStarter {
    private MultiStarter() {
    }

    public static void main(final String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: MultiStarter class.Name1 arg1 arg2 ; "
                + "className2 argN...");
            System.exit(-1);
        }
        try {
            String className = null;
            ArrayList<String> classArgs = new ArrayList<>();
            for (int i = 0; i < args.length; i++) {
                if (args[i].equals(";")) {
                    if (className != null) {
                        invokeMain(
                            className,
                            classArgs.toArray(new String[classArgs.size()]));
                        className = null;
                        classArgs.clear();
                    }
                } else if (className == null) {
                    className = args[i];
                } else {
                    classArgs.add(args[i]);
                }
            }
            if (className != null) {
                invokeMain(
                    className,
                    classArgs.toArray(new String[classArgs.size()]));
            }
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    @SuppressWarnings("rawtypes")
    private static void invokeMain(final String className, final String[] args)
        throws Exception
    {
        System.setProperty("sun.java.command", className);
        Class<?> c = Class.forName(className);
        Class[] argTypes = new Class[] {String[].class};
        Method main = c.getMethod("main", argTypes);
        System.err.println("Invoking " + className + ", args: "
            + Arrays.toString(args));
        main.invoke(null, (Object) args);
    }
}
