package ru.yandex.client.pg;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import org.apache.http.concurrent.FutureCallback;

public class AsyncResultAdapter<T> implements Handler<AsyncResult<T>> {
    private final FutureCallback<? super T> callback;

    public AsyncResultAdapter(final FutureCallback<? super T> callback) {
        this.callback = callback;
    }

    @Override
    public void handle(final AsyncResult<T> event) {
        if (event.succeeded()) {
            try {
                callback.completed(event.result());
            } catch (Exception e) {
                callback.failed(e);
            }
        } else if (event.failed()) {
            Throwable cause = event.cause();
            if (cause instanceof Exception) {
                callback.failed((Exception) cause);
            } else {
                callback.failed(new RuntimeException(cause));
            }
        } else {
            callback.cancelled();
        }
    }
}

