package ru.yandex.client.pg;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.sqlclient.SqlConnection;

public class ConnectionClosingAsyncResultHandler<T>
    implements Handler<AsyncResult<T>>
{
    private final Handler<AsyncResult<T>> handler;
    private final SqlConnection connection;

    public ConnectionClosingAsyncResultHandler(
        final Handler<AsyncResult<T>> handler,
        final SqlConnection connection)
    {
        this.handler = handler;
        this.connection = connection;
    }

    @Override
    public void handle(final AsyncResult<T> event) {
        try {
            handler.handle(event);
        } finally {
            connection.close();
        }
    }
}

