package ru.yandex.client.pg;

import java.util.Collections;
import java.util.List;

import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.desc.ColumnDescriptor;

public enum EmptyRowSet implements RowSet<Object> {
    INSTANCE;

    @Override
    public EmptyRowIterator iterator() {
        return EmptyRowIterator.INSTANCE;
    }

    @Override
    public RowSet<Object> next() {
        return null;
    }

    @Override
    public List<ColumnDescriptor> columnDescriptors() {
        return Collections.emptyList();
    }

    @Override
    public List<String> columnsNames() {
        return Collections.emptyList();
    }

    @Override
    public <V> V property(final PropertyKind<V> propertyKind) {
        return null;
    }

    @Override
    public int rowCount() {
        return 0;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public RowSet<Object> value() {
        return this;
    }

    @SuppressWarnings("unchecked")
    public static <T> RowSet<T> instance() {
        return (RowSet<T>) INSTANCE;
    }
}

