package ru.yandex.client.pg;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;

import ru.yandex.http.util.nio.client.AbstractCompletedRequestInfo;
import ru.yandex.http.util.nio.client.RequestData;

public class RowSetResultInfo extends AbstractCompletedRequestInfo {
    private final int rowCount;

    public RowSetResultInfo(
        final RequestData requestData,
        final RowSet<Row> rowSet)
    {
        super(requestData);
        rowCount = rowSet.rowCount();
    }

    @Override
    public void shortResult(final StringBuilder sb) {
        sb.append(rowCount);
    }

    @Override
    public void resultDetails(final StringBuilder sb) {
        sb.append(" completed in ");
        writeTiming(sb);
        sb.append(rowCount);
        sb.append(" rows affected");
    }
}

