package ru.yandex.client.pg;

import io.vertx.pgclient.PgPool;
import org.apache.http.HttpHost;

import ru.yandex.function.AbstractStringBuilderable;

public class Server extends AbstractStringBuilderable {
    public enum State {
        MASTER,
        SLAVE,
        DEAD
    }

    public static class Status extends AbstractStringBuilderable {
        private final State state;
        private final long lag;

        public Status(final State state, final long lag) {
            this.state = state;
            this.lag = lag;
        }

        public State state() {
            return state;
        }

        public long lag() {
            return lag;
        }

        @Override
        public void toStringBuilder(final StringBuilder sb) {
            sb.append(state);
            sb.append(",lag=");
            sb.append(lag);
        }
    }

    private final HttpHost host;
    private final PgPool pool;
    private volatile Status status = new Status(State.DEAD, 0L);

    public Server(final HttpHost host, final PgPool pool) {
        this.host = host;
        this.pool = pool;
    }

    public HttpHost host() {
        return host;
    }

    public PgPool pool() {
        return pool;
    }

    public Status status() {
        return status;
    }

    public void status(final Status status) {
        this.status = status;
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(host.getHostName());
        sb.append(':');
        sb.append(host.getPort());
        sb.append('(');
        status.toStringBuilder(sb);
        sb.append(')');
    }
}

