package ru.yandex.client.pg;

import ru.yandex.io.IOStreamUtils;

public class SqlQuery {
    private String queryName;
    private String query;

    public SqlQuery(
        final String queryName,
        final Class<?> clazz)
    {
        this(
            queryName,
            IOStreamUtils.readResourceAsStringQuiet(clazz, queryName));
    }

    public SqlQuery(
        final String queryName,
        final String query)
    {
        this.queryName = queryName;
        this.query = query;
    }

    public String queryName() {
        return queryName;
    }

    public String query() {
        return query;
    }
}

