package ru.yandex.client.pg.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.config.AbstractHttpTargetConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractPgClientConfigBuilder
    <T extends AbstractPgClientConfigBuilder<T>>
    extends AbstractHttpTargetConfigBuilder<T>
    implements PgClientConfig
{
    private List<HttpHost> hosts;
    private String database;
    private String user;
    private String password;
    private int queueSize;
    private int preparedStatementsCacheSize;
    private int idleTimeout;
    private long healthCheckInterval;
    private File pemCertificate;

    protected AbstractPgClientConfigBuilder(final PgClientConfig config) {
        super(config);
        hosts(config.hosts());
        database(config.database());
        user(config.user());
        password(config.password());
        queueSize(config.queueSize());
        preparedStatementsCacheSize(config.preparedStatementsCacheSize());
        idleTimeout(config.idleTimeout());
        healthCheckInterval(config.healthCheckInterval());
        pemCertificate(config.pemCertificate());
    }

    protected AbstractPgClientConfigBuilder(
        final IniConfig config,
        final PgClientConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        hosts = HOSTS.extract(config, defaults.hosts());
        database = DATABASE.extract(config, defaults.database());
        user = USER.extract(config, defaults.user());
        password = PASSWORD.extract(config, defaults.password());
        queueSize = QUEUE_SIZE.extract(config, defaults.queueSize());
        preparedStatementsCacheSize = PREPARED_STATEMENTS_CACHE_SIZE.extract(
            config,
            defaults.preparedStatementsCacheSize());
        idleTimeout = IDLE_TIMEOUT.extract(config, defaults.idleTimeout());
        healthCheckInterval = HEALTH_CHECK_INTERVAL.extract(
            config,
            defaults.healthCheckInterval());
        pemCertificate =
            PEM_CERTIFICATE.extract(config, defaults.pemCertificate());
    }

    @Override
    public List<HttpHost> hosts() {
        return hosts;
    }

    public T hosts(final List<HttpHost> hosts) {
        this.hosts = new ArrayList<>(hosts);
        return self();
    }

    @Override
    public String database() {
        return database;
    }

    public T database(final String database) {
        this.database = database;
        return self();
    }

    @Override
    public String user() {
        return user;
    }

    public T user(final String user) {
        this.user = user;
        return self();
    }

    @Override
    public String password() {
        return password;
    }

    public T password(final String password) {
        this.password = password;
        return self();
    }

    @Override
    public int queueSize() {
        return queueSize;
    }

    public T queueSize(final int queueSize) {
        this.queueSize = queueSize;
        return self();
    }

    @Override
    public int preparedStatementsCacheSize() {
        return preparedStatementsCacheSize;
    }

    public T preparedStatementsCacheSize(
        final int preparedStatementsCacheSize)
    {
        this.preparedStatementsCacheSize = preparedStatementsCacheSize;
        return self();
    }

    @Override
    public int idleTimeout() {
        return idleTimeout;
    }

    public T idleTimeout(final int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return self();
    }

    @Override
    public long healthCheckInterval() {
        return healthCheckInterval;
    }

    public T healthCheckInterval(final long healthCheckInterval) {
        this.healthCheckInterval = healthCheckInterval;
        return self();
    }

    @Override
    public File pemCertificate() {
        return pemCertificate;
    }

    public T pemCertificate(final File pemCertificate) {
        this.pemCertificate = pemCertificate;
        return self();
    }
}

